/**
 * settings-ui.js - Settings tab UI logic
 */

import { testApiKey } from './memory-extractor.js';
import { updateApiKey } from './app.js';

export function init(currentApiKey) {
    const apiKeyInput = document.getElementById('api-key-input');
    if (apiKeyInput && currentApiKey) {
        apiKeyInput.value = currentApiKey;
    }

    setupSettingsListeners();
}

function setupSettingsListeners() {
    const saveApiKeyBtn = document.getElementById('save-api-key-btn');
    const testApiKeyBtn = document.getElementById('test-api-key-btn');

    if (saveApiKeyBtn) {
        saveApiKeyBtn.addEventListener('click', handleSaveApiKey);
    }

    if (testApiKeyBtn) {
        testApiKeyBtn.addEventListener('click', handleTestApiKey);
    }
}

function handleSaveApiKey() {
    const input = document.getElementById('api-key-input');
    const apiKey = input.value.trim();

    if (!apiKey) {
        alert('Please enter an API key');
        return;
    }

    updateApiKey(apiKey);
    alert('API key saved!');
}

async function handleTestApiKey() {
    const input = document.getElementById('api-key-input');
    const apiKey = input.value.trim();

    if (!apiKey) {
        alert('Please enter an API key');
        return;
    }

    const statusEl = document.getElementById('api-test-status');
    if (statusEl) statusEl.textContent = 'Testing...';

    const isValid = await testApiKey(apiKey);

    if (statusEl) {
        statusEl.textContent = isValid ? '✅ Valid!' : '❌ Invalid key';
    }
}
